VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "PackUDT - SHFileOperation"
   ClientHeight    =   4545
   ClientLeft      =   3420
   ClientTop       =   1665
   ClientWidth     =   5190
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   4545
   ScaleWidth      =   5190
   ShowInTaskbar   =   0   'False
   Begin VB.CommandButton cmdExit 
      Cancel          =   -1  'True
      Caption         =   "E&xit"
      Height          =   495
      Left            =   3120
      TabIndex        =   10
      Top             =   3960
      Width           =   1455
   End
   Begin VB.CommandButton cmdCopy 
      Caption         =   "&Copy"
      Default         =   -1  'True
      Height          =   495
      Left            =   3120
      TabIndex        =   9
      Top             =   3360
      Width           =   1455
   End
   Begin VB.DirListBox dirDest 
      Height          =   1155
      Left            =   120
      TabIndex        =   6
      Top             =   2880
      Width           =   2295
   End
   Begin VB.DriveListBox drvDest 
      Height          =   315
      Left            =   120
      TabIndex        =   7
      Top             =   4080
      Width           =   2295
   End
   Begin VB.DriveListBox drvSource 
      Height          =   315
      Left            =   120
      TabIndex        =   3
      Top             =   2160
      Width           =   2295
   End
   Begin VB.FileListBox lstFiles 
      Height          =   1455
      Left            =   2520
      MultiSelect     =   2  'Extended
      TabIndex        =   4
      Top             =   960
      Width           =   2535
   End
   Begin VB.DirListBox dirSource 
      Height          =   1155
      Left            =   120
      TabIndex        =   2
      Top             =   960
      Width           =   2295
   End
   Begin VB.Label lblDest 
      Caption         =   "Label4"
      Height          =   615
      Left            =   2520
      TabIndex        =   8
      Top             =   2640
      Width           =   2535
   End
   Begin VB.Label Label3 
      Caption         =   "Select &Destination:"
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   2640
      Width           =   1575
   End
   Begin VB.Label Label2 
      Caption         =   "Select &File(s) to Copy:"
      Height          =   255
      Left            =   120
      TabIndex        =   1
      Top             =   720
      Width           =   4935
   End
   Begin VB.Label Label1 
      Caption         =   "This example demonstrates the UDT packing capabilities of the VB-Helper DLL."
      Height          =   495
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   4935
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'VB-Helper DLL, Version 2.02
'Copyright (c) 1996-97 SoftCircuits Programming(R)
'Redistributed by Permission.
'
'This package includes a helper DLL for 32-bit Visual Basic. This DLL
'provides a number of routines that perform tasks that are either
'difficult or impossible to accomplish in Visual Basic alone. Some
'sample programs are also provided to demonstrate use of the DLL.
'Please see the included help file for details on all of the routines
'included within the DLL.
'
'The VB-Helper DLL is freeware that you can use freely with your own
'programs. Any portion of the sample programs may also be incorporated
'into your own applications. However, you may only distribute
'Vbhlp32.dll as a) part of your own application that uses this DLL or
'b) within this complete and unmodified package (i.e., you may
'distribute the entire Vbhlp32.zip file).
'
'This example program was provided by:
' SoftCircuits Programming
' http://www.softcircuits.com
' P.O. Box 16262
' Irvine, CA 92623
'
'======================================================================
'
'This example demonstrates the user-defined type (UDT)
'packing capabilities of the VB-Helper DLL. It uses the
'Windows 95 API function SHFileOperation to copy one or
'more files.
'
'SHFileOperation can be called normally from VB.
'However, the ability to display a custom message
'instead of the name of each file (setting the
'FOF_SIMPLEPROGRESS flag and putting the message in
'lpszProgressTitle) does *not* work normally. This is
'because Visual Basic inserts bytes as padding into the
'SHFILEOPSTRUCT UDT which places the
'fAnyOperationsAborted member and all members that
'follow at the wrong offset.
'
'Normally, the padding Visual Basic inserts makes
'member access more efficient. However, in a few rare
'instances such as this, it prevents the call from
'working. The following code uses vbPackUDT to create a
'copy of the UDT with the padding removed.
Option Explicit

'SHFileOperation declarations
Const FO_MOVE = 1
Const FO_COPY = 2
Const FO_DELETE = 3
Const FO_RENAME = 4

Const FOF_MULTIDESTFILES = &H1      'Destination specifies multiple files
Const FOF_SILENT = &H4              'Don't display progress dialog
Const FOF_RENAMEONCOLLISION = &H8   'Rename if destination already exists
Const FOF_NOCONFIRMATION = &H10     'Don't prompt user
Const FOF_WANTMAPPINGHANDLE = &H20  'Fill in hNameMappings member
Const FOF_ALLOWUNDO = &H40          'Store undo information if possible
Const FOF_FILESONLY = &H80          'On *.*, don't copy directories
Const FOF_SIMPLEPROGRESS = &H100    'Don't show name of each file
Const FOF_NOCONFIRMMKDIR = &H200    'Don't confirm making any needed dirs

Private Type SHFILEOPSTRUCT
    hWnd As Long
    wFunc As Long
    pFrom As Long                   'Normally As String, see cmdCopy_Click comments
    pTo As Long                     'Normally As String, see cmdCopy_Click comments
    fFlags As Integer
    fAnyOperationsAborted As Long
    hNameMappings As Long
    lpszProgressTitle As String     'Used only if FOF_SIMPLEPROGRESS specified
End Type

'Must declare argument As Any instead of As SHFILEOPSTRUCT since we pass vbPackUDT handle
Private Declare Function SHFileOperation Lib "shell32.dll" Alias "SHFileOperationA" (lpFileOp As Any) As Long
'Private Declare Function VarPtr Lib "Vb40032" (pAny As Any) As Long     'VB 4

'Initialize and center form on load
Private Sub Form_Load()
    dirSource_Change
    dirDest_Change
    Move (Screen.Width - Width) \ 2, (Screen.Height - Height) \ 2
End Sub

'Perform copy of files
Private Sub cmdCopy_Click()
    Dim FileOp As SHFILEOPSTRUCT
    Dim strFrom As String, strTo As String
    Dim buff1() As Byte, buff2() As Byte
    Dim ppResult As Long

    'Parent window of copy dialog
    FileOp.hWnd = hWnd
    'Operation to perform
    FileOp.wFunc = FO_COPY
    'Make source path the current directory
    ChDrive dirSource
    ChDir dirSource
    'Get list of files to be copied
    strFrom = GetFileSpecs
    If Len(strFrom) = 0 Then
        MsgBox "No files selected to copy"
        Exit Sub
    End If
    'Destination (extra Chr$(0) signals last item in list)
    strTo = lblDest & Chr$(0)
    'Options (specify custom message)
    FileOp.fFlags = FileOp.fFlags Or FOF_SIMPLEPROGRESS
    FileOp.lpszProgressTitle = "Custom message here!!!"
    'Pack the UDT:
    'Note: Although VBHLP32.DLL will pack UDTs that contain
    'variable-length strings, we must perform some
    'conversions on the pFrom and pTo members. This is
    'because VBHLP32.DLL, like most DLLs, considers the
    'Chr$(0), which Visual Basic appends to all strings
    'sent to DLLs, to signify the end of the string.
    'However, in this unusual case, the pFrom and pTo
    'members can specify mutliple filenames with Chr$(0)
    'between each one (and a double Chr$(0) to signal the
    'end of the list). To deal with this, we convert
    'strFrom and strTo to ANSI strings stored in a Byte
    'array. We then use VarPtr to pass the address of the
    'byte array to SHFileoperation.
    buff1 = StrConv(strFrom & Chr$(0), vbFromUnicode)
    buff2 = StrConv(strTo & Chr$(0), vbFromUnicode)
    FileOp.pFrom = VarPtr(buff1(0))
    FileOp.pTo = VarPtr(buff2(0))
    vbPackUDT FileOp, ppResult, "llllills"
    'Call SHFileOperation
    If SHFileOperation(ByVal ppResult) <> 0 Then
        MsgBox "There was an error calling SHFileOperation."
    End If
    'Unpack UDT (not needed here but would be necessary
    'to access any values returned in the UDT)
    vbUnpackUDT FileOp, ppResult
    'Free packed memory
    vbPackUDTFree ppResult
End Sub

'Returns a string with all the currently-selected source
'files. Each file is separated with Chr$(0)
Private Function GetFileSpecs() As String
    Dim i As Integer
    Dim strPath As String, strFileSpecs As String

    strPath = lstFiles.Path
    If Right$(strPath, 1) <> "\" Then
        strPath = strPath & "\"
    End If
    For i = 0 To (lstFiles.ListCount - 1)
        If lstFiles.Selected(i) Then
            strFileSpecs = strFileSpecs & strPath & lstFiles.List(i) & Chr$(0)
        End If
    Next i
    GetFileSpecs = strFileSpecs
End Function

Private Sub cmdExit_Click()
    Unload Me
End Sub

Private Sub dirDest_Change()
    lblDest = dirDest
End Sub

Private Sub dirSource_Change()
    lstFiles = dirSource
End Sub

Private Sub drvDest_Change()
    dirDest = drvDest
End Sub

Private Sub drvSource_Change()
    dirSource = drvSource
End Sub

